/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.rss;

public class RSSItemCount {
    private String name;
    private String pubDate;
    private int count;
    private int type;
    private int code = 0;

    public final static int DAY = 1;
    public final static int HOUR = 2;


    public RSSItemCount(int type, String name, String pubDate, int count){
        setName(name);
        setCount(count);
        setType(type);
        setPubDate(pubDate);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public int getCount() {
        return count;
    }

    private void setCount(int count) {
        this.count = count;
    }

    public String getPubDate() {
        return pubDate;
    }

    private void setPubDate(String pubDate) {
        String date = "";
        if(type == DAY){
            try{
                date = pubDate.trim().split(" ")[0];
                String[] ss = date.split("-");
                // code de tri : 1 an < 12.5 mois de 40 jours
                code = Integer.parseInt(ss[0])*500+Integer.parseInt(ss[1])*40+
                         Integer.parseInt(ss[2]);
            } catch(NumberFormatException nfe){
                code = 0;
            }
        } else if(type == HOUR) {
            int hr = Integer.parseInt(pubDate.trim().split(" ")[1].split(":")[0]);
            date = hr+"h-"+(hr+1)+"h";
            // Pour un tri par tranche horaire
            code = hr;
        }
        this.pubDate = date;
    }

    @Override
    public int hashCode(){
        return code;
    }
}
